%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Diffusion maps on one-dimensional Gaussian data
% in Example 6.4
% Created by John Harlim
% Last edited: March 26, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


clear all, close all, clc

dim =1;                 % intrinsic dimensoon
x = sqrt(0.04)*randn(10000,dim);    % random Gaussian data
x2 = sort(x);
epsilon = 0.00001;      % bandwidth parameter
k =512;                 % Number of KNN
k2 = 64;                % Number of nearest neighbor for KDE
operator = 2;           % operator- 1 - Laplace-Beltrami operator, 2 - generator of grad system 
nvars = 11;             % number of eigenvectors computed

tic
% Diffusion maps with specified epsilon and dimension
[basis1,eigs1,~,~,peq1,qest1,~] = VBDM(x2,k,k2,nvars,operator,epsilon,dim);

% Diffusion maps with specified epsilon
[basis2,eigs2,~,~,peq1,qest2,dim2] = VBDM(x2,k,k2,nvars,operator,epsilon);

% Diffusion maps with automated estimation on epsilon and dimension
[basis3,eigs3,epsilon3,~,peq3,qest3,dim3] = VBDM(x2,k,k2,nvars,operator);

toc

% plotting eigenvalues
grey = [.4 .4 .4];
mode = [0:nvars-1];
figure(1)
hold on
plot(mode,eigs1,'k','linewidth',2)
plot(mode,eigs2,'-.','color',grey,'linewidth',2)
plot(mode,eigs3,'k--','linewidth',2)
plot(mode,-mode/0.04,'k--')
hold off
set(gca,'fontsize',16)
legend('no auto','d auto','\epsilon and d auto','analytic')
title('Eigenvalues of $\hat{\cal L}$','interpreter','latex')
xlabel('k')
%print -depsc -r100 eigvaluesplot.eps

%% plotting the first three non-trivial eigenvectors

% regression to rotate the estimated eigenvectors to align with the
% analytic eigenfunction for visualization comparison
figure(2)
c2 = (basis1(:,2)'*basis1(:,2))\(basis1(:,2)'*x2/0.04);
basisplot1 = basis1(:,2)*c2;
c2 = (basis2(:,2)'*basis2(:,2))\(basis2(:,2)'*x2/0.04);
basisplot2 = basis2(:,2)*c2;
c2 = (basis3(:,2)'*basis3(:,2))\(basis3(:,2)'*x2/0.04);
basisplot3 = basis3(:,2)*c2;

subplot(3,3,1)
hold on
plot(x2(1:10:end),basisplot1(1:10:end),'o','linewidth',2,'color',grey)
plot(x2(1:10:end),x2(1:10:end)/0.04,'k')
hold off
set(gca,'fontsize',16)
ylabel('$\varphi_1(x)$','interpreter','latex')
title('no auto')
%legend('estimate','true',2)
ylim([-30 30])

subplot(3,3,2)
hold on
plot(x2(1:10:end),basisplot2(1:10:end),'o','linewidth',2,'color',grey)
plot(x2(1:10:end),x2(1:10:end)/0.04,'k')
hold off
set(gca,'fontsize',16)
title('d auto')
ylim([-30 30])


subplot(3,3,3)
hold on
plot(x2(1:10:end),basisplot3(1:10:end),'o','linewidth',2,'color',grey)
plot(x2(1:10:end),x2(1:10:end)/0.04,'k')
hold off
set(gca,'fontsize',16)
title('\epsilon and d auto')
ylim([-30 30])


c2 = (basis1(:,3)'*basis1(:,3))\(basis1(:,3)'*(x2.^2/0.04-1)/2/0.04);
basisplot1 = basis1(:,3)*c2;
c2 = (basis2(:,3)'*basis2(:,3))\(basis2(:,3)'*(x2.^2/0.04-1)/2/0.04);
basisplot2 = basis2(:,3)*c2;
c2 = (basis3(:,3)'*basis3(:,3))\(basis3(:,3)'*(x2.^2/0.04-1)/2/0.04);
basisplot3 = basis3(:,3)*c2;

subplot(3,3,4)
hold on
plot(x2(1:10:end),basisplot1(1:10:end),'o','linewidth',2,'color',grey)
plot(x2(1:10:end),(x2(1:10:end).^2/0.04-1)/2/0.04,'k')
hold off
set(gca,'fontsize',16)
ylabel('$\varphi_2(x)$','interpreter','latex')
ylim([-300 300])

subplot(3,3,5)
hold on
plot(x2(1:10:end),basisplot2(1:10:end),'o','linewidth',2,'color',grey)
plot(x2(1:10:end),(x2(1:10:end).^2/0.04-1)/2/0.04,'k')
hold off
ylim([-300 300])
set(gca,'fontsize',16)

subplot(3,3,6)
hold on
plot(x2(1:10:end),basisplot3(1:10:end),'o','linewidth',2,'color',grey)
plot(x2(1:10:end),(x2(1:10:end).^2/0.04-1)/2/0.04,'k')
hold off
ylim([-300 300])
set(gca,'fontsize',16)

c2 = (basis1(:,4)'*basis1(:,4))\(basis1(:,4)'*(x2.^3/0.04-3*x2)/12/0.04^2);
basisplot1 = basis1(:,4)*c2;
c2 = (basis2(:,4)'*basis2(:,4))\(basis2(:,4)'*(x2.^3/0.04-3*x2)/12/0.04^2);
basisplot2 = basis2(:,4)*c2;
c2 = (basis3(:,4)'*basis3(:,4))\(basis3(:,4)'*(x2.^3/0.04-3*x2)/12/0.04^2);
basisplot3 = basis3(:,4)*c2;

subplot(3,3,7)
hold on
plot(x2(1:10:end),basisplot1(1:10:end),'o','linewidth',2,'color',grey)
plot(x2(1:10:end),(x2(1:10:end).^3/0.04-3*x2(1:10:end))/12/0.04^2,'k')
hold off
set(gca,'fontsize',16)
ylabel('$\varphi_3(x)$','interpreter','latex')
xlabel('x')
ylim([-600 600])

subplot(3,3,8)
hold on
plot(x2(1:10:end),basisplot2(1:10:end),'o','linewidth',2,'color',grey)
plot(x2(1:10:end),(x2(1:10:end).^3/0.04-3*x2(1:10:end))/12/0.04^2,'k')
hold off
set(gca,'fontsize',16)
xlabel('x')
ylim([-600 600])

subplot(3,3,9)
hold on
plot(x2(1:10:end),basisplot3(1:10:end),'o','linewidth',2,'color',grey)
plot(x2(1:10:end),(x2(1:10:end).^3/0.04-3*x2(1:10:end))/12/0.04^2,'k')
hold off
set(gca,'fontsize',16)
xlabel('x')
ylim([-600 600])

orient tall
%print -depsc -r100 eigfcnsplot.eps




